<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Chat\V3;

use Twilio\ListResource;
use Twilio\Version;

class ChannelList extends ListResource {
    /**
     * Construct the ChannelList
     *
     * @param Version $version Version that contains the resource
     */
    public function __construct(Version $version) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [];
    }

    /**
     * Constructs a ChannelContext
     *
     * @param string $serviceSid Service Sid.
     * @param string $sid A string that uniquely identifies this Channel.
     */
    public function getContext(string $serviceSid, string $sid): ChannelContext {
        return new ChannelContext($this->version, $serviceSid, $sid);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        return '[Twilio.Chat.V3.ChannelList]';
    }
}