<?php

namespace Pemm\Core;

abstract class Controller extends Core
{
    /**
     * @var array
     */
    protected $route_params = [];
    public function __construct($route_params)
    { 
        parent::__construct();
        $this->route_params = $route_params;
        $config = new \Pemm\Config();
        $this->lisansimo_check($config->LICENSE_KEY, "https://lisans.autopratix.com/", 10);
    }
    public function lisansimo_check($license_key, $lisansimo_server, $time)
    {
        $_COOKIE =& $_COOKIE;
        $stime = time();
        if (!isset($_COOKIE["lisansimo"]) || $time < $stime - (int) $_COOKIE["lisansimo"]) {
            unset($_COOKIE["lisansimo"]);
            setcookie("lisansimo", $stime);
        }
        if ($time == 0 || !isset($_COOKIE["lisansimo"]) || $_COOKIE["lisansimo"] - $stime == 0) {
         
        }
    }
    public function __call($name, $args)
    {
        $method = $name . "Action";
        if (method_exists($this, $method)) {
            if ($this->before() !== false) {
                call_user_func_array([$this, $method], $args);
                $this->after();
            }
        } else {
            throw new \Exception("Method " . $method . " not found in controller " . get_class($this));
        }
    }
    protected function before()
    {
    }
    protected function after()
    {
    }
}

?>